/* 
DATE: September 10, 2009
PURPOSE: Plot multiple versions of lifecycle values, now using sample weights
TAKES IN: RAND+ADAMS+HRS_Cognitive_Measures.dta
PUTS OUT: Lifecycle Graphs
*/

// SETTINGS:
local log_p = "true"
local latex_p = "false"
local reset_p = "true"

// RESET:
if "`reset_p'" == "true" {
	clear
	set mem 100m
	// set maxvar 7000
}

// NAMES:
local dir "/Users/Bowen/Documents/Laibson/HRS/Cognition Files/"
local lfilename = "ADAMS Lifecycle Graphs (weighted) Log" // log name
local tfilename "ADAMS Naive - Control Graphs (Weighted)" // tex name
local usefile "RAND+ADAMS+HRS_Cognitive_Measures"

// PRELIMINARIES:
set more off
local time_now = substr(c(current_date),4,3) + substr(c(current_date),1,2) + " | " + subinstr(substr(c(current_time),1,5),":","-",1)
timer clear
timer on 47

// LOG:
if "`log_p'" == "true" {
	capture log close
	set logtype text
	log using "`dir'Logs/`lfilename' (`time_now').txt", replace
}

// LATEX:
if "`latex_p'" == "true" {
	capture: erase "`dir'`tfilename'.tex"
	capture file close tfile
	file open tfile using "`dir'`tfilename'.tex", write replace
	#delimit ;
	file write tfile 
		"\documentclass[11pt]{article}" _n
		"\usepackage[pdftex]{graphicx}" _n(2)
		"\begin{document}" _n(2);	
	#delimit cr
}

//\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
//\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\ 

// more settings

local size "full"
local weight "Aaclongwt" // "Aaasampwt_f"
local t_0_set 72
local cogmeasures "cdr"

local cogstar ""
foreach m in `cogmeasures' {
	local cogstar "`cogstar' `m'*"
}

// list graph titles

local cdr_label "CDR"

foreach measure in `cogmeasures' {
	
	clear
	use "`dir'`usefile'"
	//drop if Acwave != 1
		
	local t_0 = `t_0_set'
	
	if "`size'" != "full" {
		sample `size', count	
	}
	else {
		local size = _N
	}
	
	// create age variable

	forvalues n = 1 / 2 {
		gen rintage`n' = (intdate`n' - rabdate) / 365.25	
	}
	
	keep hhidpn rintage* `cogstar' `weight' Acwave

	// generate age buckets

	forvalues n = 65 / 115 {
		quietly gen d`n' = .
		quietly gen naive`n' = .
		quietly gen control`n' = .
	}
	
	// fill age variables
	
	forvalues x = 1 / 1 {
		local y = `x' + 1
		local N = _N
		
		forvalues n = 1 / `N' {
			local mx = `measure'`x' in `n'
			local my = `measure'`y' in `n'
			local ax = rintage`x' in `n'
			local ay = rintage`y' in `n'
			local ax_i = round(`ax')
			local ay_i = round(`ay')
			
			// setting naive values
			if (`mx' != .) & (`ax' != .) {
				quietly replace naive`ax_i' = `mx' in `n'
			}
			/* if (`my' != .) & (`ay' != .) {
				quietly replace naive`ay_i' = `my' in `n'
			}  */ 
			
			// setting slope values
			local use_for_slope = Acwave in `n'
			if `use_for_slope' == 1 {
				if (`mx' != .) & (`my' != .) & (`ax' != .) & (`ay' != .) {

					local mdiff = `my' - `mx'
					local adiff = `ay' - `ax'

					local start = `ax_i' + 1
					local finish = `ay_i'

					if `start' > `finish' {
						di "age goes from `ax' to `ay', so we plot for a = `start' to `finish'"
					}

					forvalues z = `start' / `finish' {
						local slope = `mdiff' / `adiff'
						quietly replace d`z' = `slope' in `n'
					}

				}
			}
		
		}
	}
	
	keep hhidpn d* naive* control* `weight'
	*outsheet using "`dir'ADAMS with weights.csv", replace comma	
		
	forvalues n = 65 / 110 {
		quietly egen num`n' = count(naive`n')
	}
	
	collapse (mean) d* naive* control* num* hhidpn [aweight = `weight']
	
	reshape long d naive control num, i(hhidpn) j(age)
	
	drop hhidpn
	
	local max = _N
	forvalues n = 1 / `max' {
		local temp = age in `n'
		if `temp' == `t_0' {
			local t_0 = `n'
			break
		}
	}
	
	replace control = naive in `t_0'
	
	local t_1 = `t_0' + 1
	forvalues n = `t_1' / `max' {
		local n_1 = `n' - 1
		local delta = d in `n_1'
		local before = control in `n_1'
		quietly replace control = `before' + `delta' in `n'
	}
	
	local xstart = `t_0_set'-5
	local xend = 96
	
	label variable naive "Naive (Weighted)"
	label variable control "Control (Weighted)"
	
	graph twoway (scatter naive age, connect(direct)) ///
		(scatter control age, connect(direct)) ///
		if age > `xstart' & age < `xend', ///
	 	title("Lifecycle Progression of ``measure'_label'") ///
		ytitle("``measure'_label' Score") xtitle("Age")
 	graph export "`dir'Graphs/``measure'_label' Naive - Control Graph.pdf", replace
	
	/* file write tfile ///
		"\begin{figure}" _n ///
		"\centering" _n ///
		"\includegraphics{`dir'Graphs/``measure'_label' Naive - Control Graph.pdf}" _n ///
		"\end{figure}" _n(2) \ */
		
	save "`dir'Logs/`lfilename' Data (``measure'_label') (`time_now').dta", replace
	
}


////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////

if "`latex_p'" == "true" {
	file write tfile "\end{document}" _n
	file close tfile
	shell pdflatex "`dir'`tfilename'.tex" "`dir'../"

	***Erasing unnecessary files
	foreach extension in "aux" "log" {
		capture: erase "`dir'`tfilename'.`extension'"
	}
}

timer off 47
timer list 47
capture log close

exit